<?php
    $sliding_banner = element('sliding_banner.element');
    $notice = content('notice.content');
    $yourLinks = content('links.content');

    // 🔥 IMPORTANT FIX
    $user = auth()->user();
?>

<div id="appCapsule">

    <!-- ================= TRENDING SLIDER ================= -->
    <div class="trend-slider">
        <div class="trend-slide active">
            <span class="trend-badge">🔥 TRENDING</span>
            <h4>Bitcoin Price Moving Fast</h4>
            <p>High volatility in BTC / USDT market</p>
            <a href="<?php echo e(route('user.mining')); ?>" class="trend-btn">Start Mining</a>
        </div>

        <div class="trend-slide">
            <span class="trend-badge">🚀 HOT</span>
            <h4>Ethereum Breakout Zone</h4>
            <p>ETH showing strong bullish momentum</p>
            <a href="<?php echo e(route('user.mining')); ?>" class="trend-btn">Start Mining</a>
        </div>

        <div class="trend-slide">
            <span class="trend-badge">⚡ ALERT</span>
            <h4>Altcoins Are Pumping</h4>
            <p>SOL, BNB & DOGE gaining volume</p>
            <a href="<?php echo e(route('user.mining')); ?>" class="trend-btn">View Mining</a>
        </div>
    </div>

    <!-- ================= MAIN WALLET (FIXED) ================= -->
    <div class="qx-card">
        <div class="qx-card-body">
            <div class="row align-items-center">
                <div class="col-6">
                    <h6 class="qx-title">Main Wallet</h6>

                    
                    <h3 class="qx-balance">
                        <?php echo e(@$general->currency_sym ?? '$'); ?>

                        <?php echo e(showAmount($user->balance ?? 0)); ?>

                    </h3>
                </div>

                <div class="col-6 text-end">
                    <a href="<?php echo e(route('user.usdt.index')); ?>" class="qx-btn">
                        Deposit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= LIVE MARKET ================= -->
    <div class="qx-market">
        <h5 class="qx-market-title">Live Market</h5>

        <div class="tradingview-widget-container">
            <div class="tradingview-widget-container__widget"></div>
            <script src="https://s3.tradingview.com/external-embedding/embed-widget-market-quotes.js" async>
            {
              "width": "100%",
              "height": 420,
              "symbolsGroups": [
                {
                  "name": "Crypto",
                  "symbols": [
                    { "name": "BINANCE:BTCUSDT", "displayName": "BTC / USDT" },
                    { "name": "BINANCE:ETHUSDT", "displayName": "ETH / USDT" },
                    { "name": "BINANCE:BNBUSDT", "displayName": "BNB / USDT" },
                    { "name": "BINANCE:SOLUSDT", "displayName": "SOL / USDT" },
                    { "name": "BINANCE:XRPUSDT", "displayName": "XRP / USDT" },
                    { "name": "BINANCE:DOGEUSDT", "displayName": "DOGE / USDT" }
                  ]
                }
              ],
              "showSymbolLogo": true,
              "colorTheme": "dark",
              "isTransparent": true,
              "locale": "en"
            }
            </script>
        </div>
    </div>

</div>

<!-- ================= CSS ================= -->
<style>
body {
    background: #0b0e11;
    color: #eaecef;
    font-family: Inter, system-ui, sans-serif;
}

/* ===== TREND SLIDER ===== */
.trend-slider {
    margin: 14px;
    padding: 20px;
    border-radius: 18px;
    background: linear-gradient(135deg, #1c0d30, #0a0416);
    border: 1px solid rgba(255,120,0,0.35);
    box-shadow: 0 0 35px rgba(255,120,0,0.25);
    overflow: hidden;
}

.trend-slide {
    display: none;
    animation: fade 0.5s ease;
}
.trend-slide.active { display: block; }

.trend-badge {
    font-size: 11px;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 20px;
    background: linear-gradient(135deg, #ff4d4d, #ff9900);
    color: #000;
}

.trend-slide h4 {
    margin: 8px 0 4px;
    font-size: 18px;
    font-weight: 700;
}

.trend-slide p {
    font-size: 13px;
    color: #c9d1d9;
}

.trend-btn {
    margin-top: 6px;
    display: inline-block;
    background: linear-gradient(135deg, #ff4d4d, #ff9900);
    color: #000;
    padding: 10px 18px;
    border-radius: 12px;
    font-size: 13px;
    font-weight: 700;
    text-decoration: none;
}

/* ===== WALLET ===== */
.qx-card {
    background: linear-gradient(145deg, #15181d, #0e1116);
    border-radius: 16px;
    margin: 14px;
    border: 1px solid #1f2329;
}

.qx-card-body { padding: 18px; }
.qx-title { font-size: 13px; color: #8b949e; }
.qx-balance { font-size: 24px; font-weight: 700; color: #00eaff; }
.qx-btn {
    background: linear-gradient(135deg, #00eaff, #0066ff);
    padding: 8px 16px;
    border-radius: 9px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
}

/* ===== MARKET ===== */
.qx-market {
    margin: 14px;
    background: #0f141a;
    border-radius: 16px;
    padding: 12px;
    border: 1px solid #1f2329;
}

@keyframes  fade {
    from { opacity: 0; transform: translateY(8px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- ================= JS ================= -->
<script>
    const slides = document.querySelectorAll('.trend-slide');
    let index = 0;

    function runSlider() {
        slides.forEach(s => s.classList.remove('active'));
        slides[index].classList.add('active');
        index = (index + 1) % slides.length;
    }

    runSlider();
    setInterval(runSlider, 4000);
</script>
<?php /**PATH /home/lfnnmvrc/bdmicrojob.turbostar26-27.xyz/core/resources/views/theme3/ajax/home.blade.php ENDPATH**/ ?>