<div class="d-none" id="currentPath">Invest_Log</div>

<script>
    
        function getCountDown(elementId, seconds) {
            var times = seconds;
            
            var x = setInterval(function() {
                var distance = times * 1000;
                
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "COMPLETE";
                }
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                if ($('#currentPath').html() == 'Invest_Log') {
                    document.getElementById(elementId).innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
                }else{
                    clearInterval(x);
                }
                times--;
            }, 1000);
        }
</script>

<!-- Logs Navigation -->
<?php echo $__env->make('theme3.includes.user.logs_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Invest History -->
<div class="section my-3">
    <div class="transactions">
        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- item -->
        <a href="#" class="item pt-1 pb-1 px-3">
            <div class="detail">
                <img src="<?php echo e(asset('asset/images/2d-icon/3/history.png')); ?>" class="image-block imaged w48" alt="">

                <div>
                    <strong>
                        <?php if($data->gateway_id == 0): ?>
                            <?php echo e(__('Invest Using Balance')); ?>

                        <?php else: ?>
                            <?php echo e(@$data->gateway->gateway_name ?? 'Account Transfer'); ?>

                        <?php endif; ?>
                    </strong>
                    <p class="small text-secondary">
                        Trx: <b class="text-info"><?php echo e($data->transaction_id); ?></b>
                        <br>
                        <?php echo e(showDateTime($data->created_at, 'd-m-Y')); ?> | <?php echo e(diffForHumans($data->created_at)); ?>

                        <br>
                        Upcoming Payment: 
                        <b class="text-info">
                            <p id="count_<?php echo e($loop->iteration); ?>"></p>
                            <script>
                                if ($('#currentPath').html() == 'Invest_Log') {
                                    getCountDown("count_<?php echo e($loop->iteration); ?>", "<?php echo e(now()->diffInSeconds($data->next_payment_date)); ?>")
                                }
                            </script>
                        </b>
                    </p>
                </div>
            </div>
            <div align="right" class="col-auto">
                <h5 class="text-danger mb-1">
                    <?php echo e(__($general->currency_sym)); ?> <?php echo e(showAmount($data->amount)); ?>

                </h5>
                <?php if($data->payment_status == 1): ?>
                    <span class="badge badge-success style--light"><?php echo app('translator')->get('Complete'); ?></span>
                <?php elseif($data->payment_status == 2): ?>
                    <span class="badge badge-warning style--light"><?php echo app('translator')->get('Pending'); ?></span>
                <?php elseif($data->payment_status == 3): ?>
                    <span class="badge badge-danger style--light"><?php echo app('translator')->get('Rejected'); ?></span>
                <?php endif; ?>
            </div>
        </a>
        <!-- * item -->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<!-- * Invest History -->

<?php /**PATH /home/yesunte3/ye-sundemoweb.pro/v26/core/resources/views/theme3/user/ajax/invest_log.blade.php ENDPATH**/ ?>