<?php
    $yourLinks = content('links.content');
?>

<div id="appCapsule">

    <!-- ================= WALLET CARD ================= -->
    <div class="qx-card">
        <div class="qx-card-body">
            <div class="row align-items-center">
                <div class="col-6">
                    <h6 class="qx-title">Main Wallet</h6>
                    <h3 class="qx-balance">
                        <?php echo e($general->currency_sym); ?> <?php echo e(showAmount($user->balance)); ?>

                    </h3>
                </div>
                <div class="col-6 text-end">
                    <a href="<?php echo e(route('user.usdt.index')); ?>" class="qx-btn">
                        Deposit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= LIVE MARKET (SMALL) ================= -->
    <div class="qx-market small-market">
        <div class="qx-market-header">
            <h6>Live Market</h6>
            <span class="qx-market-badge">LIVE</span>
        </div>

        <div class="tradingview-widget-container">
            <div class="tradingview-widget-container__widget"></div>
            <script src="https://s3.tradingview.com/external-embedding/embed-widget-market-quotes.js" async>
            {
              "width": "100%",
              "height": 160,
              "symbolsGroups": [
                {
                  "name": "Crypto",
                  "symbols": [
                    { "name": "BINANCE:BTCUSDT", "displayName": "BTC" },
                    { "name": "BINANCE:ETHUSDT", "displayName": "ETH" },
                    { "name": "BINANCE:BNBUSDT", "displayName": "BNB" }
                  ]
                }
              ],
              "showSymbolLogo": false,
              "colorTheme": "dark",
              "isTransparent": true,
              "locale": "en"
            }
            </script>
        </div>
    </div>

    <!-- ================= QUICK ACTIONS ================= -->
    <div class="row text-center mt-3">
        <a class="col-3 customLink" href="<?php echo e(route('user.team',1)); ?>">
            <img src="/imag/11543340.png" width="40">
            <div class="small-font">My Team</div>
        </a>

        <a class="col-3 customLink" href="<?php echo e(route('user.withdraw.setting.bank.card')); ?>">
            <img src="/imag/bank-flat.png" width="40">
            <div class="small-font">Bank</div>
        </a>

        <a class="col-3" href="#">
            <img src="/imag/vecteezy_google-play-store-icon-logo-symbol_22613026.png" width="40">
            <div class="small-font">App</div>
        </a>

        <a class="col-3 profileSettingBtn" href="#">
            <img src="/imag/7915522.png" width="40">
            <div class="small-font">Account</div>
        </a>
    </div>

    <!-- ================= STATS ================= -->
    <div class="section mt-3">
        <div class="row">
            <div class="col-6">
                <div class="stat-box">
                    <div class="title">Total Deposit</div>
                    <div class="value text-danger">
                        <?php echo e($general->currency_sym); ?> <?php echo e(showAmount($totalDeposit)); ?>

                    </div>
                </div>
            </div>

            <div class="col-6">
                <div class="stat-box">
                    <div class="title">Total Withdraw</div>
                    <div class="value text-success">
                        <?php echo e($general->currency_sym); ?> <?php echo e(showAmount($withdraw)); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= LINKS ================= -->
    <ul class="listview image-listview inset mt-3">
        <li>
            <a href="<?php echo e($yourLinks->data->telegram); ?>" class="item">
                <div class="icon-box">
                    <img width="22" src="https://cdn-icons-png.flaticon.com/128/1391/1391058.png">
                </div>
                <div class="in">Telegram</div>
            </a>
        </li>

        <li>
            <a href="<?php echo e(route('pages','about')); ?>" class="item">
                <div class="icon-box">
                    <img width="22" src="https://cdn-icons-png.flaticon.com/128/2115/2115962.png">
                </div>
                <div class="in">About Us</div>
            </a>
        </li>
    </ul>

    <!-- ================= SIGN OUT ================= -->
    <div class="section mt-3">
        <a href="<?php echo e(route('user.logout')); ?>" class="btn btn-danger w-100">
            Sign Out
        </a>
    </div>

</div>

<!-- ================= STYLE ================= -->
<style>
body{
    background:#0b0e11;
    color:#eaecef;
    font-family:Inter,system-ui,sans-serif;
}

.qx-card{
    margin:14px;
    border-radius:16px;
    background:linear-gradient(145deg,#15181d,#0e1116);
    border:1px solid #1f2329;
    box-shadow:0 10px 25px rgba(0,0,0,.6);
}

.qx-card-body{padding:16px}
.qx-title{font-size:13px;color:#8b949e}
.qx-balance{font-size:22px;font-weight:700;color:#00eaff}

.qx-btn{
    background:linear-gradient(135deg,#00eaff,#0066ff);
    color:#000;
    padding:7px 14px;
    border-radius:8px;
    font-size:13px;
    font-weight:700;
    text-decoration:none;
}

.qx-market{
    margin:14px;
    padding:12px;
    border-radius:14px;
    background:#0f141a;
    border:1px solid #1f2329;
}

.small-market{
    padding:10px;
}

.qx-market-header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:6px;
}

.qx-market-header h6{
    margin:0;
    font-size:13px;
    font-weight:700;
}

.qx-market-badge{
    font-size:10px;
    padding:3px 8px;
    border-radius:12px;
    background:linear-gradient(135deg,#00eaff,#0066ff);
    color:#000;
    font-weight:700;
}

.stat-box{
    background:#0f141a;
    padding:12px;
    border-radius:12px;
    margin-top:10px;
    text-align:center;
}

.stat-box .title{
    font-size:12px;
    color:#8b949e;
}

.stat-box .value{
    font-size:14px;
    font-weight:700;
}

.small-font{
    font-size:12px;
    margin-top:4px;
}
</style>
<?php /**PATH /home/lfnnmvrc/bdmicrojob.turbostar26-27.xyz/core/resources/views/theme3/user/ajax/dashboard.blade.php ENDPATH**/ ?>