<div class="mt-2 mb-3">
    <div class="container">
        <div class="card mb-2">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="mb-0 text-pink">Investment Plans</h3>
                        <p class="mb-0">Invest Now and Earn Money</p>
                    </div>
                    <div class="col-auto">
                        <img width="100px" src="<?php echo e(asset('asset/images/icons-3d/vip-lock.png')); ?>" alt="">
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $plan_exist = App\Models\Payment::where('plan_id', $plan->id)
                        ->where('user_id', Auth::id())
                        ->where('next_payment_date', '!=', null)
                        ->where('payment_status', 1)
                        ->count();
                ?>
                <div class="col-6 mb-2">
                    <div class="card bg-pink-light-alt">
                        <div class="card-body">
                            
                            <div class="text-center">
                                <img style="height: 70px" src="<?php echo e(asset('asset/images/plan-img/' . $plan->plan_image)); ?>" alt="">
                            </div>
                            <h2 class="text-center mt-3 mb-1"><?php echo e($plan->plan_name); ?></h2>
                            <h4 class="text-center">
                                <span class="plan-amount">
                                    <?php echo e(number_format($plan->return_interest, 2)); ?>

                                    <?php if($plan->interest_status == 'percentage'): ?>
                                        <?php echo e('%'); ?>

                                    <?php else: ?>
                                        <?php echo e(@$general->site_currency); ?>

                                    <?php endif; ?>
                                </span>
                                <span class="plan-status"><?php echo e($plan->time->name); ?></span>
                            </h4>

                            <?php if($plan->amount_type == 0): ?>
                                <div class="row border-bottom">
                                    <div class="col ps-0" style="padding-right: 3px !important;">Min</div>
                                    <div class="col-auto px-0"><?php echo e(showAmount($plan->minimum_amount)); ?> <?php echo e(@$general->currency_sym); ?></div>
                                </div>
                                <div class="row border-bottom ">
                                    <div class="col ps-0" style="padding-right: 3px !important;">Max</div>
                                    <div class="col-auto px-0"><?php echo e(showAmount($plan->maximum_amount)); ?> <?php echo e(@$general->currency_sym); ?></div>
                                </div>
                            <?php else: ?>
                                <div class="row border-bottom">
                                    <div class="col ps-0" style="padding-right: 3px !important;">Amount</div>
                                    <div class="col-auto px-0"><?php echo e(showAmount($plan->amount)); ?> <?php echo e(@$general->currency_sym); ?></div>
                                </div>
                            <?php endif; ?>

                            <div class="row border-bottom">
                                <div class="col ps-0" style="padding-right: 3px !important;">For</div>
                                <div class="col-auto px-0">
                                    <?php if($plan->return_for == 1): ?>
                                        <?php echo e($plan->how_many_time); ?> <?php echo e(__('Times')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('Lifetime')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row border-bottom">
                                <div class="col ps-0" style="padding-right: 3px !important;">Capital Back</div>
                                <div class="col-auto px-0">
                                    <?php if($plan->capital_back == 1): ?>
                                        YES
                                    <?php else: ?>
                                        NO
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 mt-3 mb-1">
                                    <?php if($plan_exist >= $plan->invest_limit): ?>
                                        <a class="btn btn-sm btn-primary plan-btn w-100 disabled" href="#"><?php echo e(__('Limit Over')); ?></a>
                                    <?php else: ?>
                                        <?php if(auth()->guard()->check()): ?>
                                            <button class="btn btn-pink-light plan-btn balance w-100" data-plan="<?php echo e($plan); ?>" data-url=""><?php echo e(__('Invest Now')); ?></button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

            <?php endif; ?>
        </div>
    </div>
</div>


<div class="modal fade" id="invest" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="<?php echo e(route('user.investmentplan.submit')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Invest Now')); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="form-group">
                            <label for=""><?php echo e(__('Invest Amount')); ?></label>
                            <input type="text" name="amount" class="form-control">
                            <input type="hidden" name="plan_id" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-success"><?php echo e(__('Invest Now')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<!--Investment Plan-->
<script>
    $(function() {
        'use strict'

        $(document).on('click', '.balance', function() {
            const modal = $('#invest');
            modal.find('input[name=plan_id]').val($(this).data('plan').id);
            modal.modal('show')
        })
    })
</script>


<?php /**PATH /home/yesunte3/ye-sundemoweb.pro/v26/core/resources/views/theme3/pages/ajax/invest.blade.php ENDPATH**/ ?>