<div class="d-none " id="currentPath">login_page</div>

<section class="section px-4 pt-120 pb-120 ">

    <div class="row justify-content-center glass-bg">
        <div class="col">
            <div class="login-area ">

                <div class="text-center mb-3">
                    <img width="230px" src="" alt="">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-auto">
                            <div class="input-group">
                                <button class="btn btn-outline-light" type="button" id="loginPageBtn">Login</button>
                                <button class="btn btn-outline-light" type="button" id="registerPageBtn">Signup</button>
                            </div>
                        </div>
                    </div>
                </div>

                <form class="action-form mt-50 loginForm" id="loginForm" action="<?php echo e(route('user.login')); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="text" name="username" placeholder="<?php echo app('translator')->get('Enter Username'); ?>"
                                class="form-control " value="<?php echo e(old('username')); ?>">
                        </div>
                    </div><!-- form-group end -->


                    <div class="form-group boxed">
                        <div class="input-wrapper">
                           
                            <input type="password" name="password" placeholder="<?php echo app('translator')->get('Enter Password'); ?>"
                                class="form-control text-warning" value="<?php echo e(old('password')); ?>">
                        </div>
                    </div><!-- form-group end -->

                    <button type="submit" class="btn login-btn w-100 mt-3 py-1 loginSubmitBtn">Login</button>
                   
                </form>
            </div>
        </div>
    </div>

</section>

<!-- jquery -->
<script src="<?php echo e(asset('asset/theme3/frontend/js/jquery.min.js')); ?>"></script>
<!-- nav_script -->
<?php echo $__env->make('theme3.includes.auth.nav_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    $(document).on('submit', '#loginForm', function (e) {
        e.preventDefault();
        $('.loginSubmitBtn').html(BtnSPIN);
        var formData = new FormData($('#loginForm')[0]);
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('user.login')); ?>",
            data: formData,
            dataType: "json",
            contentType: false, // The content type used when sending data to the server.
            processData: false,
            success: function (res) {
                notifyMsg(res.msg, res.cls);
                $('.loginSubmitBtn').html('Login');
                if (res.cls === 'success') {
                    setTimeout(() => {
                        window.location.href = "<?php echo e(route('user.dashboard')); ?>";
                    }, 1000);
                }
            },
            error: function (err) {
                $('.loginSubmitBtn').html('Login');
                let errors = err.responseJSON.errors;
                let result = '';
                $.each(errors, function (index, value) {
                    console.log(value);
                    result += value+'<br>'
                });

                notifyMsg(result, 'error')
            }
        });

    });
</script>

<?php /**PATH /home/yesunte3/ye-sundemoweb.pro/Trade/core/resources/views/theme3/user/auth/ajax/login.blade.php ENDPATH**/ ?>