@extends(template().'layout.master2')

@section('content2')
<div class="container">

    <!-- ================= REFERRAL LINK ================= -->
    <div class="card mb-2">
        <div class="card-body pt-2 pb-2">
            <label class="form-label mb-1 small">Referral Link</label>
            <div class="input-group input-group-sm">
                <input
                    type="text"
                    id="referralURL"
                    class="form-control"
                    value="{{ route('user.register', [Auth::user()->username]) }}"
                    readonly
                >
                <button class="btn btn-gr-red px-3 copytext" type="button">
                    <i class="fas fa-copy"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- ================= TEAM SUMMARY ================= -->
    <div class="card">
        <div class="card-body py-2">
            <div class="row g-2 text-center">

                <div class="col-6">
                    <div class="card bg-gr-red">
                        <div class="card-body p-2">
                            <div class="small">Total Team</div>
                            <h6 class="mb-0">
                                {{ teamSize($user->id,1)+teamSize($user->id,2)+teamSize($user->id,3) }}
                            </h6>
                        </div>
                    </div>
                </div>

                <div class="col-6">
                    <div class="card bg-gr-red">
                        <div class="card-body p-2">
                            <div class="small">Total Earn</div>
                            <h6 class="mb-0">
                                {{ $general->currency_sym }}{{ showAmount($commison) }}
                            </h6>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="card bg-gr-red mt-1">
                        <div class="card-body p-2">
                            <div class="small">Work Team</div>
                            <h6 class="mb-0">
                                {{ depoTeamSize($user->id,1)+depoTeamSize($user->id,2)+depoTeamSize($user->id,3) }}
                            </h6>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- ================= LEVEL BUTTONS ================= -->
    <div class="card mt-2">
        <div class="card-body py-2">
            <div class="row gx-1">
                @for($i = 1; $i <= 3; $i++)
                    <div class="col-4">
                        <a
                            href="{{ route('user.team',$i) }}"
                            class="btn btn-gr-red btn-sm w-100 @if($lev == $i) disabled @endif"
                        >
                            Lev{{ $i }} ({{ teamSize($user->id,$i) }})
                        </a>
                    </div>
                @endfor
            </div>
        </div>
    </div>

    <!-- ================= TEAM LIST ================= -->
    <div class="my-3">
        {{ showUserLevel($user->id, $lev) }}
    </div>

</div>
@endsection

@push('script')
<script>
    document.querySelector('.copytext').addEventListener('click', function () {
        let input = document.getElementById('referralURL');
        input.select();
        input.setSelectionRange(0, 99999);
        document.execCommand('copy');
        notifyMsg('Referral link copied!', 'success');
    });
</script>
@endpush
