<div class="d-none" id="currentPath">register_page</div>

<section class="section px-4 pt-120 pb-120">
    <div class="row justify-content-center">
        <div class="col-12 col-md-6">
            <div class="login-area">

                <!-- ===== Title ===== -->
                <h4 class="text-center text-light mb-1">Create Your Account</h4>
                <p class="text-center mb-4 text-warning">
                    Sign up to start trading
                </p>

                <!-- ===== Register Form ===== -->
                <form class="loginForm" action="{{ route('user.register') }}" method="post">
                    @csrf

                    <!-- Username -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Username</label>
                        <div class="input-wrapper">
                            <input
                                type="text"
                                name="username"
                                id="username"
                                class="form-control text-warning"
                                placeholder="Choose a username"
                                value="{{ old('username') }}"
                            >
                            <small class="usernameCheck text-danger"></small>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Email Address</label>
                        <div class="input-wrapper">
                            <input
                                type="email"
                                name="email"
                                id="email"
                                class="form-control text-warning"
                                placeholder="Enter your email"
                                value="{{ old('email') }}"
                            >
                            <small class="emailCheck text-danger"></small>
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Password</label>
                        <div class="input-wrapper">
                            <input
                                type="password"
                                name="password"
                                class="form-control text-warning"
                                placeholder="Create a password"
                            >
                        </div>
                    </div>

                    <!-- Confirm Password -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Confirm Password</label>
                        <div class="input-wrapper">
                            <input
                                type="password"
                                name="password_confirmation"
                                class="form-control text-warning"
                                placeholder="Confirm password"
                            >
                        </div>
                    </div>

                    <!-- Referral Code -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Referral Code (Optional)</label>
                        <div class="input-wrapper">
                            <input
                                type="text"
                                name="reffered_by"
                                id="reffer"
                                class="form-control text-warning"
                                placeholder="Referral code"
                                value="{{ request()->reffer }}"
                            >
                            <small class="refferCheck text-danger"></small>
                        </div>
                    </div>

                    <!-- Submit -->
                    <button type="submit" class="btn login-btn w-100 mt-2 py-2">
                        Sign Up
                    </button>

                    <!-- Login Link -->
                    <p class="text-center mt-3" style="color:#838383;">
                        Already registered?
                        <span class="text-warning cursor-pointer" id="loginPageBtn">
                            Log in
                        </span>
                    </p>
                </form>

            </div>
        </div>
    </div>
</section>

<!-- ================= SCRIPTS ================= -->
<script src="{{ asset('asset/theme3/frontend/js/jquery.min.js') }}"></script>

<script>
/* Username check */
$(document).on('focusout', '#username', function () {
    let username = $(this).val();
    if(!username) return;

    $.post("{{ route('user.username.exist') }}", {
        _token: "{{ csrf_token() }}",
        username: username
    }, function (res) {
        $('.usernameCheck').html(
            res.cls === 'success' ? 'Username already exists!' : ''
        );
    });
});

/* Email check */
$(document).on('focusout', '#email', function () {
    let email = $(this).val();
    if(!email) return;

    $.post("{{ route('user.email.exist') }}", {
        _token: "{{ csrf_token() }}",
        email: email
    }, function (res) {
        $('.emailCheck').html(
            res.cls === 'success' ? 'Email already exists!' : ''
        );
    });
});

/* Referral check */
$(document).on('keyup', '#reffer', function () {
    let reffer = $(this).val();
    if(!reffer){
        return $('.refferCheck').html('');
    }

    $.post("{{ route('user.reffer.exist') }}", {
        _token: "{{ csrf_token() }}",
        reffer: reffer
    }, function (res) {
        $('.refferCheck')
            .removeClass('text-danger text-success')
            .addClass(res.cls === 'success' ? 'text-success' : 'text-danger')
            .html(res.msg);
    });
});
</script>
