<div class="d-none" id="currentPath">login_page</div>

<section class="section px-4 pt-120 pb-120">
    <div class="row justify-content-center">
        <div class="col-12 col-md-6">
            <div class="login-area">

                <!-- ===== Title ===== -->
                <h4 class="text-center text-light mb-2">Login your account</h4>
                <p class="text-center mb-4" style="color:#f0b90b;">
                    After login you can trade
                </p>

                <!-- ===== Login Form ===== -->
                <form class="loginForm" id="loginForm" action="{{ route('user.login') }}" method="post">
                    @csrf

                    <!-- Username -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Username</label>
                        <div class="input-wrapper">
                            <input
                                type="text"
                                name="username"
                                class="form-control text-warning"
                                placeholder="Enter username"
                                value="{{ old('username') }}"
                            >
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="form-group boxed mb-3">
                        <label class="form-label text-warning">Password</label>
                        <div class="input-wrapper">
                            <input
                                type="password"
                                name="password"
                                class="form-control text-warning"
                                placeholder="Enter password"
                            >
                        </div>
                    </div>

                    <!-- Submit -->
                    <button type="submit" class="btn login-btn w-100 mt-2 py-2 loginSubmitBtn">
                        Login
                    </button>

                    <!-- Register -->
                    <p class="text-center mt-3" style="color:#838383;">
                        Not a member?
                        <span class="text-warning cursor-pointer" id="registerPageBtn">
                            Sign Up
                        </span>
                    </p>

                </form>
            </div>
        </div>
    </div>
</section>

<!-- ================= SCRIPTS ================= -->
<script src="{{ asset('asset/theme3/frontend/js/jquery.min.js') }}"></script>
@include('theme3.includes.auth.nav_script')

<script>
$(document).on('submit', '#loginForm', function (e) {
    e.preventDefault();

    $('.loginSubmitBtn').html(BtnSPIN);

    let formData = new FormData(this);

    $.ajax({
        type: "POST",
        url: "{{ route('user.login') }}",
        data: formData,
        dataType: "json",
        contentType: false,
        processData: false,

        success: function (res) {
            notifyMsg(res.msg, res.cls);
            $('.loginSubmitBtn').html('Login');

            if (res.cls === 'success') {
                setTimeout(() => {
                    window.location.href = "{{ route('user.dashboard') }}";
                }, 1000);
            }
        },

        error: function (err) {
            $('.loginSubmitBtn').html('Login');

            let errors = err.responseJSON.errors;
            let msg = '';
            $.each(errors, function (k, v) {
                msg += v + '<br>';
            });

            notifyMsg(msg, 'error');
        }
    });
});
</script>
